function [p r]=calibrarDistorsionFuncionRacional(puntos,puntosC,cx,cy)

% [p r]=calibrarDistorsionFuncionRacional(puntos,puntosC,cx,cy)
% calibra la distorsion radial con el conjunto de puntos distorsionados y
% corregidos
% p- devuelve el resultado de los parametros de distorsion
% r- devuelve el resulado del residuo de la estimacion de la funcion


centro=[cx cy];
%diferencias=puntosC-puntos;
M=[];

for i=1:size(puntos,1)
    incU=puntos(i,:)-centro;
    incUc=puntosC(i,:)-centro;
    
    %x=[puntos(i,1)^2 puntos(i,1)*puntos(i,2) puntos(i,2)^2 puntos(i,1) puntos(i,2) 1];
    x=[incU(1)^2 incU(1)*incU(2) incU(2)^2 incU(1) incU(2) 1];
        
    %M=[M; -x zeros(1,6) x*puntosC(i,1); zeros(1,6) -x x*puntosC(i,2)];
    M=[M; -x zeros(1,6) x*incUc(1); zeros(1,6) -x x*incUc(2)];
end

[u,s,v] = svd(M);
p=v(:,18);
p=[p; cx; cy];
r=s(18,18);

%'Busqueda NO LINEAL utilizando Lenvenberg-Madquart de todos los puntos
%para que cumplan el crossRatio
options = optimset('Largescale','off','TolX',0.00000001,'TolFun',0.00000001,'Display','final','Jacobian','off','MaxFunEvals',1000000,'Algorithm','levenberg-marquardt');%,'MaxFunEvals',2000000,'MaxIter',20000);
[parOptimos,resnorm,residual,exitflag,output,lambda,jacobian] = lsqnonlin(@funcionDistorsionFuncionRacional,p,[],[],options,puntos,puntosC);

p=parOptimos;
r=residual;







