function [p r]=calibrarDistorsionRadialTangencial(puntos,puntosC,cx,cy)

% [p r]=calibrarDistorsionRadial(puntos,puntosC,cx,cy)
% calibra la distorsion radial con el conjunto de puntos distorsionados y
% corregidos
% p- devuelve el resultado de los parametros de distorsion
% r- devuelve el resulado del residuo de la estimacion de la funcion


centro=[cx cy];
diferencias=puntosC-puntos;
M=[];
m=[];
for i=1:size(puntos,1)
    incU=puntos(i,:)-centro;
    r=incU*incU';
    M=[M; incU(1)*r incU(1)*(r^2) (r+2*incU(1)^2) 2*incU(1)*incU(2);incU(2)*r incU(2)*(r^2) 2*incU(1)*incU(2) (r+2*incU(2)^2)];
    m=[m; diferencias(i,1); diferencias(i,2)];
end

p=inv(M'*M)*M'*m;
p=[p;cx;cy];

%'Busqueda NO LINEAL utilizando Lenvenberg-Madquart de todos los puntos
%para que cumplan el crossRatio
options = optimset('Largescale','off','TolX',0.00000001,'TolFun',0.00000001,'Display','final','Jacobian','off','MaxFunEvals',1000000,'Algorithm','levenberg-marquardt');%,'MaxFunEvals',2000000,'MaxIter',20000);
[parOptimos,resnorm,residual,exitflag,output,lambda,jacobian] = lsqnonlin(@funcionDistorsionRadialTangencial,p,[],[],options,puntos,puntosC);

p=parOptimos;
r=residual;







