function puntosC=corregirPuntosFET(puntos,s,lambda,cx,cy)

% puntosC=corregirPuntosFET(puntos,s,lambda,cx,cy)
% Arregla la 'puntos' partiendo de los coeficientes s y lambda que modelan la
% distorsin segun el modelo FET. cx,cy representan el centro de la distorsin
% que suele coincidir con el centro de la imagen.

centro=[cx cy];
puntosC=[];

for i=1:size(puntos,1)
    incU=puntos(i,:)-centro;
    alfa=abs(atan(incU(2)/incU(1)));
    r=sqrt(incU*incU');
    rc=s*log(1+lambda*r);
    u=cx-rc*cos(alfa)*sign(incU(1));
    v=cy-rc*sin(alfa)*sign(incU(2));
    puntosC=[puntosC;u v];
end
    
    



