function puntosC=corregirPuntos(puntos,k1,k2,p1,p2,cx,cy)

% puntosC=corregirPuntos(puntos,k1,k2,p1,p2,cx,cy)
% Arregla la 'puntos' partiendo de los coeficientes k1,k2,p1,p2 que modelan la
% distorsin. K1 y K2 modelan la distorsin radial y p1, p2 la distorsin
% tangencial o de descentrado. cx,cy representan el centro de la distorsin
% que suele coincidir con el centro de la imagen.

centro=[cx cy];
puntosC=[];

for i=1:size(puntos,1)
    incU=puntos(i,:)-centro;
    r=incU*incU';
    v=puntos(i,1)+incU(1)*(k1*r+k2*r^2)+(p1*(r+2*incU(1)^2)+2*p2*incU(1)*incU(2));
    u=puntos(i,2)+incU(2)*(k1*r+k2*r^2)+(p2*(r+2*incU(2)^2)+2*p1*incU(1)*incU(2));
    puntosC=[puntosC;v u];
end
    
    



