function F=funcionCrossRatioRectas(puntos,n,crossRatio)
% Funcion que representa el valor del CrossRatio para todos los puntos de una regilla enlazados entre ellos para utilizarla con el mtodo
% iterativo de busqueda no lineal de Leveberg-Madquart
%
% F=funcionCrossRatio(puntos,n,crossRatio)
%
% puntos - conjunto de puntos en la regilla ordenados por rectas una
%           destrs de otra formando una matriz
% n - nmero de puntos por recta
% crossRatio - Valor del CrossRatio. Es nico para todas las combinaciones de los
%       puntos, ya que la cuadricula se supone regular en los dos ejes.

nRectas = size(puntos,1)/n; % nmero de rectas

F=[];
matrizRectas1=[];
matrizRectas2=[];

for i=0:1:nRectas-1
    recta=puntos(i*n+1:i*n+n,:);
    c=crossRatioPuntos(recta);
        
    % Valor de la funcin para el cross ratio
    F = [F; c-crossRatio];
    
    % se estima una recta con los puntos. 
    r=[recta ones(size(recta,1),1)];
    [u,s,v] = svd(r);
    matrizRectas1=[matrizRectas1 v(:,3)];
    F = [F; s(3,3)];
end

for i=1:1:n
    recta=[];
    for j=i:n:size(puntos,1)
        recta=[recta; puntos(j,:)];
    end
    c=crossRatioPuntos(recta);
       
    % Valor de la funcin para el cross ratio
    F = [F; c-crossRatio];
    
    % se estima una recta con los puntos. 
    r=[recta ones(size(recta,1),1)];
    [u,s,v] = svd(r);
    matrizRectas2=[matrizRectas2 v(:,3)];
    F = [F; s(3,3)];
end

