function F=funcionDistorsionFET(parametrosDistorsion,puntosMatriz,puntosCorregidos)
% Funcion que representa el valor el error de ajuste de dos conjuntos de
% puntos segn los parmetros de distorsion de la cmara. Utilizado para el
% mtodo iterativo de busqueda no lineal de Leveberg-Madquart de los
% parmetros de distorsion de la cmra que mejor se ajustan a dos conjuntos
% de puntos
%
% F=funcionDistorsion(puntosMatriz,puntosCorregidos,parametrosDistorsion)
% parametrosDistorsion=[s, lambda, cx, cy]'

s=parametrosDistorsion(1);
lambda=parametrosDistorsion(2);
cx=parametrosDistorsion(3);
cy=parametrosDistorsion(4);

puntosFET=corregirPuntosFET(puntosMatriz,s,lambda,cx,cy);

F=reshape(puntosCorregidos-puntosFET,size(puntosMatriz,1)*2,1);


