function F=funcionDistorsionPFET(parametrosDistorsion,puntosMatriz,puntosCorregidos)
% Funcion que representa el valor el error de ajuste de dos conjuntos de
% puntos segn los parmetros de distorsion de la cmara. Utilizado para el
% mtodo iterativo de busqueda no lineal de Leveberg-Madquart de los
% parmetros de distorsion de la cmra que mejor se ajustan a dos conjuntos
% de puntos
%
% F=funcionDistorsion(puntosMatriz,puntosCorregidos,parametrosDistorsion)
% parametrosDistorsion=[s, lambda, cx, cy]'

a0=parametrosDistorsion(1);
a1=parametrosDistorsion(2);
a2=parametrosDistorsion(3);
a3=parametrosDistorsion(4);
a4=parametrosDistorsion(5);
cx=parametrosDistorsion(6);
cy=parametrosDistorsion(7);

puntosPFET=corregirPuntosPFET(puntosMatriz,a0,a1,a2,a3,a4,cx,cy);

F=reshape(puntosCorregidos-puntosPFET,size(puntosMatriz,1)*2,1);


