clear all
close all
echo off
clc
iptsetpref('ImshowBorder', 'tight');

fprintf('\n\n-------------------------------------------\n')
fprintf(' Metric Lens Distortion Calibration (MLDC) \n')
fprintf('-------------------------------------------\n \n');
fprintf(' Carlos Ricolfe-Viala\n cricolfe@isa.upv.es \n')

fprintf('\n\nTWO STEPS\n   1st - Undistort points detected in the image\n   2nd - Compute several non linear lens distortion models with the detected points and the corrected ones\n\n')



x=10:5:630;
y=10:5:470;
[XI,YI] = meshgrid(x',y);

% SE CARGAN LOS DATOS DE LAS IMAGENES 
for k=1:1
    % se carga la imagen
    %fnombreImagenS=sprintf('im%d.bmp', k);
    fnombreImagenS=sprintf('patron2mm.bmp');
    imagen=imread(fnombreImagenS);

    % se cargan los puntos de la imagen
    %distorsionados
    %fichero=sprintf('im%d-O.txt', k);
    fichero=sprintf('puntos2mm.txt', k);
    puntos=load(fichero);
    
    %corregidos
    %fichero=sprintf('im%d-C.txt', k);
    %fichero=sprintf('puntos2mmC.txt', k);
    %puntosC=load(fichero);
    nRows=9;
    [puntosC, residuo]=pointsCorrection(puntos, nRows, 1.1378);%1.7778);    
    
    nPuntos=size(puntos,1);
    %nPuntos=nPuntos/2;

    % puntos corregidos si se utilizan diferentes modelos 

    % RADIAL TANGENCIAL
    [p r]=calibrarDistorsionRadialTangencial(puntos(1:nPuntos,:),puntosC(1:nPuntos,:),282.8090,241.7086); % este centro de la imagen se ha obtenido del resultado que da la busqueda no lineal de los parmetros de la cmara y los puntos que dan como resultado puntosC
    k1=p(1);
    k2=p(2);
    p1=p(3);
    p2=p(4);
    cx=p(5);
    cy=p(6);
    fprintf('---RESULTADOS RADIAL Y TANGENCIAL---\n')
    p(1:4)'
    p(5:6)'
    r=[mean(abs(r)) std(abs(r)) max(abs(r)) min(abs(r))]
    puntosModeloRT=corregirPuntosRT(puntos,k1,k2,p1,p2,cx,cy);
    centroRT=[cx cy];

    %FET
    [p r]=calibrarDistorsionFET(puntos(1:nPuntos,:),puntosC(1:nPuntos,:),282.8090,241.7086); % este centro de la imagen se ha obtenido del resultado que da la busqueda no lineal de los parmetros de la cmara y los puntos que dan como resultado puntosC
    s=p(1);
    lambda=p(2);
    cx=p(3);
    cy=p(4);
    fprintf('---RESULTADOS FET---\n')
    p(1:2)'
    p(3:4)'
    r=[mean(abs(r)) std(abs(r)) max(abs(r)) min(abs(r))]
    puntosModeloFET=corregirPuntosFET(puntos,s,lambda,cx,cy);
    centroFET=[cx cy];

    %PFET
    [p r]=calibrarDistorsionPFET(puntos(1:nPuntos,:),puntosC(1:nPuntos,:),282.8090,241.7086); % este centro de la imagen se ha obtenido del resultado que da la busqueda no lineal de los parmetros de la cmara y los puntos que dan como resultado puntosC
    cx=p(6);
    cy=p(7);
    fprintf('---RESULTADOS PFET---\n')
    p(1:5)'
    p(6:7)'
    r=[mean(abs(r)) std(abs(r)) max(abs(r)) min(abs(r))]
    puntosModeloPFET=corregirPuntosPFET(puntos,p(1),p(2),p(3),p(4),p(5),cx,cy);
    centroPFET=[cx cy];

    %FUNCION RACIONAL
    [p r]=calibrarDistorsionFuncionRacional(puntos(1:nPuntos,:),puntosC(1:nPuntos,:),282.8090,241.7086); % este centro de la imagen se ha obtenido del resultado que da la busqueda no lineal de los parmetros de la cmara y los puntos que dan como resultado puntosC
    cx=p(19);
    cy=p(20);
    fprintf('---RESULTADOS FUNCION RACIONAL---\n')
    p(1:18)'
    p(19:20)'
    r=[mean(abs(r)) std(abs(r)) max(abs(r)) min(abs(r))]
    puntosModeloFR=corregirPuntosFuncionRacional(puntos,p);
    centroFR=[cx cy];

    % FIGURA CON TODOS LOS PUNTOS JUNTOS
    figure()
    imshow(imagen)
    hold on
    plot(puntos(:,1),puntos(:,2),'xy')
    plot(puntosC(:,1),puntosC(:,2),'+r')
    plot(puntosModeloRT(:,1),puntosModeloRT(:,2),'ob')
    plot(puntosModeloFET(:,1),puntosModeloFET(:,2),'*m')
    plot(puntosModeloPFET(:,1),puntosModeloPFET(:,2),'sc')
    plot(puntosModeloFR(:,1),puntosModeloFR(:,2),'vm')
    plot(centroRT(1),centroRT(2),'ob')
    plot(centroFET(1),centroFET(2),'om')
    plot(centroPFET(1),centroPFET(2),'oc')
    plot(centroFR(1),centroFR(2),'vm')
    legend('Detected','Corrected','RT','FET','PFET','FR');

    % SUPERFICIES
   
    % MODELO POLINOMIAL RADIAL-TANGENCIAL
    diferenciasM=puntosC-puntosModeloRT;
    diferencias=sqrt(diag(diferenciasM*diferenciasM'));
    ZIx = griddata(puntosC(:,1),puntosC(:,2),diferencias,x',y);
    figure
    mesh(XI,YI,ZIx)
    hold on
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'.')
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'r*')
    xlabel('coordinates U of the image')
    ylabel('coordinates V of the image')
    zlabel('error')
    title('Radial-Tangencial')
    zlim([0 20])

    % MODELO FET
    diferenciasM=puntosC-puntosModeloFET;
    diferencias=sqrt(diag(diferenciasM*diferenciasM'));
    ZIx = griddata(puntosC(:,1),puntosC(:,2),diferencias,x',y);
    figure
    mesh(XI,YI,ZIx)
    hold on
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'.')
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'r*')
    xlabel('coordinates U of the image')
    ylabel('coordinates V of the image')
    zlabel('error')
    title('FET')
    zlim([0 20])

    % MODELO PFET
    diferenciasM=puntosC-puntosModeloPFET;
    diferencias=sqrt(diag(diferenciasM*diferenciasM'));
    ZIx = griddata(puntosC(:,1),puntosC(:,2),diferencias,x',y);
    figure
    mesh(XI,YI,ZIx)
    hold on
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'.')
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'r*')
    xlabel('coordinates U of the image')
    ylabel('coordinates V of the image')
    zlabel('error')
    title('PFET')
    zlim([0 20])

   
    % MODELO RF
    diferenciasM=puntosC-puntosModeloFR;
    diferencias=sqrt(diag(diferenciasM*diferenciasM'));
    ZIx = griddata(puntosC(:,1),puntosC(:,2),diferencias,x',y);
    figure
    mesh(XI,YI,ZIx)
    hold on
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'.')
    plot3(puntosC(:,1),puntosC(:,2),diferencias,'r*')
    xlabel('image coordinates U (pixel) ')
    ylabel('image coordinates V (pixel) ')
    zlabel('error')
    title('RF')
    zlim([0 20])
    
end

