function [imagePointsC, residual]=pointsCorrection(imagePoints, nRows, crossRatio)

% imagePointsC=pointsCorrection(imagePoints, nRow, crossRatio)
% imagePoints - points extracted from image
% nRows       - number of rows in the image
% crossRatio  - crossRatio of points in the template


if mod(size(imagePoints,1),nRows) == 0
    
    fprintf('\nCorrecting points. \n It lasts 3 min. in a AMD Atlon Dual Core 5600+ 2.81 Ghz 2Gb RAM \n \n\nWorking ...');
    cr=funcionCrossRatioRectas(imagePoints,nRows,crossRatio);

    % Non linear searchin using Lenvenberg-Madquart. It finishs when all points
    % accomplish the crossRatio and belongs to straight lines
    options = optimset('Largescale','off','TolX',0.00000001,'TolFun',0.00000001,'Display','final','Jacobian','off','MaxFunEvals',10000000,'Algorithm','levenberg-marquardt');%,'MaxFunEvals',2000000,'MaxIter',20000);
    [imagePointsC,resnorm,residual,exitflag,output,lambda,jacobian] = lsqnonlin(@funcionCrossRatioRectas,imagePoints,[],[],options,nRows,crossRatio);
    
else
    fprintf('\n ERROR: number of points in the image must be multiple of the number of rows \n\n');
end

