warning off;

clc;
clear;

% read data

% read T1 volume
name ='t1_icbm_normal_1mm_pn0_rf0.rawb';
fid = fopen(name,'r');    
s=[181,217,181];
ima1=zeros(s(1:3));
for z=1:s(3),    
  ima1(:,:,z) = fread(fid,s(1:2),'uchar');
end;
fclose(fid);

% read T2 volume
name ='t2_icbm_normal_1mm_pn0_rf0.rawb';
fid = fopen(name,'r');    
s=[181,217,181];
ima2=zeros(s(1:3));
for z=1:s(3),    
  ima2(:,:,z) = fread(fid,s(1:2),'uchar');
end;
fclose(fid);

ima1=double(ima1(:,:,1:180));
ima2=double(ima2(:,:,1:180));

% small volume (comment this two lines to process the whole volume)
ima1=ima1(50:100,50:100,101:154);
ima2=ima2(50:100,50:100,101:154);

s=size(ima1);

ind=find(ima2(:)>10);

% reduce ima2 a factor f
f=9;
for i=1:f:s(3)
  nima2(:,:,(i+f-1)/f)=mean(ima2(:,:,i:i+f-1),3);  
end

R=range(nima2(:));

% reconstruc using Nearest Neighbour

ori=((1+f)/2);
[x,y,z] = meshgrid(1:s(2),1:s(1),ori:f:1-ori+s(3));
[xi,yi,zi] = meshgrid(1:s(2),1:s(1),1:s(3));
enima2 = interp3(x,y,z,nima2,xi,yi,zi,'nearest'); 
error_nn=sqrt(mean((ima2(ind)-enima2(ind)).^2));
psnr_nn=20*log10(R/error_nn)

% reconstruc using linear interpolation
bima0 = interp3(x,y,z,nima2,xi,yi,zi,'linear'); 
for i=1:floor(f/2)
  bima0(:,:,i) = bima0(:,:,floor(f/2)+1);
end
for i=s(3)-floor(f/2):s(3)
  bima0(:,:,i) = bima0(:,:,s(3)-floor(f/2));
end
error_lin=sqrt(mean((ima2(ind)-bima0(ind)).^2));
psnr_lin=20*log10(R/error_lin)

% reconstruc using cubic interpolation
bima1 = interp3(x,y,z,nima2,xi,yi,zi,'cubic'); 
for i=1:floor(f/2)
  bima1(:,:,i) = bima1(:,:,floor(f/2)+1);
end
for i=s(3)-floor(f/2):s(3)
  bima1(:,:,i) = bima1(:,:,s(3)-floor(f/2));
end
error_cubic=sqrt(mean((ima2(ind)-bima1(ind)).^2));
psnr_cubic=20*log10(R/error_cubic)

% reconstruc using spline interpolation
[x,y,z] = ndgrid(1:s(1),1:s(2),ori:f:1-ori+s(3));
[xi,yi,zi] = ndgrid(1:s(1),1:s(2),1:s(3));
bima2 = interpn(x,y,z,nima2,xi,yi,zi,'spline'); 
for i=1:floor(f/2)
  bima2(:,:,i) = bima2(:,:,floor(f/2)+1);
end
for i=s(3)-floor(f/2):s(3)
  bima2(:,:,i) = bima2(:,:,s(3)-floor(f/2));
end
error_spline=sqrt(mean((ima2(ind)-bima2(ind)).^2));
psnr_spline=20*log10(R/error_spline)

% Regularization parameters 
tol=0.01;
level=32;
v=3;

% Proposed method
i=1;
lima=enima2;
while(1)    
copy=lima;
[lima]=cMRegularizar(ima1,lima,v,f,level,5);    
error_proposed(i)=sqrt(mean((ima2(ind)-lima(ind)).^2));
psnr_proposed(i)=20*log10(R/error_proposed(i))
d2(i)=mean(abs(copy(:)-lima(:)))
if(level<=2) 
    if(d2(i)<tol) break; end;
else level=level/2
end;
i=i+1;
plot(psnr_proposed,'o-')
xlabel('Iter')
ylabel('PSNR')
drawnow
end

% show results

cor=round(s(1)/2);
sag(:,:)=ima1(cor,:,:);
sag0(:,:)=nima2(cor,:,:);
sag1(:,:)=ima2(cor,:,:);
sag2(:,:)=enima2(cor,:,:);
sag3(:,:)=bima0(cor,:,:);
sag4(:,:)=bima1(cor,:,:);
sag5(:,:)=bima2(cor,:,:);
sag6(:,:)=lima(cor,:,:);


clf
colormap(gray)
subplot(3,3,1)
image(imrotate(sag,90)/4)
title('reference')
subplot(3,3,2)
image(imrotate(sag1,90)/4)
title('original HR')
subplot(3,3,3)
image(imrotate(sag0,90)/4)
title('original LR')
subplot(3,3,4)
image(imrotate(sag2,90)/4)
title(['NN PSNR=' num2str(psnr_nn)])
subplot(3,3,5)
image(imrotate(sag3,90)/4)
title(['Linear PSNR=' num2str(psnr_lin)])
subplot(3,3,6)
image(imrotate(sag4,90)/4)
title(['Bicubic PSNR=' num2str(psnr_cubic)])
subplot(3,3,7)
image(imrotate(sag5,90)/4)
title(['B-Spline PSNR=' num2str(psnr_spline)])
subplot(3,3,8)
image(imrotate(sag6,90)/4)
title(['Proposed PSNR=' num2str(psnr_proposed(end))])

