%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% demo program  for PRI-NL-PCA
%
%   Authors:
%   Jose V. Manjon - jmanjon@fis.upv.es
%   Pierrick Coupe - pierrick.coupe@labri.fr
%
%   Copyright (C) 2008-2015 Jose V. Manjon and Pierrick Coupe 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

warning off;
clc
clear

%set the settings of your experiment

rician=1;      %rician=0(Gaussian noise)      rician=1(Rician noise)
variable=0;    %variable=0(Homogeneus noise)  variable=0(spatially variable noise)

% read volume
name ='t1_icbm_normal_1mm_pn0_rf0.rawb';
fid = fopen(name,'r');    
s=[181,217,181];
ima=zeros(s(1:3));
for z=1:s(3),    
  ima(:,:,z) = fread(fid,s(1:2),'uchar');
end;
fclose(fid);
ima=double(ima);

% subvolume (do a test with a smaller volume)
ima=ima(50:80,50:80,50:80);

s=size(ima);
R=max(ima(:));
indi=find(ima>10);
sw = [1 1 1]; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Different noise levels
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:2:9
  i  
sigma=i*max(ima(:))/100;
randn('seed',0)

if(variable)
  map = ones(3,3,3);
  map(2,2,2)=3;
  [x1,y1,z1] = meshgrid(1:3,1:3,1:3);
  [x2,y2,z2] = meshgrid(1:2/(s(2)-1):3,1:2/(s(1)-1):3,1:2/(s(3)-1):3);
  map = sigma*interp3(x1,y1,z1,map,x2,y2,z2,'cubic'); 
  if(rician) rima=sqrt((ima+randn(size(ima)).*map).^2+(randn(size(ima)).*map).^2);
  else       rima=ima+randn(size(ima)).*map;
  end
else
  if(rician) rima=sqrt((ima+randn(size(ima))*sigma).^2+(randn(size(ima))*sigma).^2);
  else       rima=ima+randn(size(ima))*sigma;
  end 
  map=ones(s)*sigma;
end

oerror0(i)=sqrt(mean((ima(indi)-rima(indi)).^2))
opsnr0(i)=20*log10(R/oerror0(i))
ossim0(i)= ssim_index3d(rima,ima,sw,indi)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
% NL-PCA filtering 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tic
[fima1,map1]=NL_PCA(rima,rician);
t1(i)=toc

oerror1(i)=sqrt(mean((ima(indi)-fima1(indi)).^2))
opsnr1(i)=20*log10(R/oerror1(i))
ossim1(i)= ssim_index3d(fima1,ima,sw,indi)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
% PRI-NL-PCA filtering 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mv=9;
fima2=cPRI_NL_PCA(rima,mv,1,map1,fima1,rician); 
t2(i)=toc

oerror2(i)=sqrt(mean((ima(indi)-fima2(indi)).^2))
opsnr2(i)=20*log10(R/oerror2(i))
ossim2(i)= ssim_index3d(fima2,ima,sw,indi)

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Show results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

op0=mean(opsnr0(1:2:9))
op1=mean(opsnr1(1:2:9))
op2=mean(opsnr2(1:2:9))
 
figure
clf
plot(1:2:9,opsnr0(1:2:9),'g')
hold on
plot(1:2:9,opsnr1(1:2:9),'b')
plot(1:2:9,opsnr2(1:2:9),'r')
xlabel('Noise level(%)')
ylabel('PSNR')
 
% % %results
figure
clf
colormap(gray);
nc=round(s(3)/2);
subplot(2,2,1),imagesc(imrotate(ima(:,:,nc),90)),xlabel('Noise free')
subplot(2,2,3),imagesc(imrotate(rima(:,:,nc),90)),xlabel('noisy')
subplot(2,2,2),imagesc(imrotate(fima1(:,:,nc),90)),xlabel('NL-PCA')
subplot(2,2,4),imagesc(imrotate(fima2(:,:,nc),90)),xlabel('PRI-NL-PCA')


