public class GrupoFiguras{
    static final int MAX_NUM_FIGURAS = 10;

    private Figura [] listaFiguras = new Figura [MAX_NUM_FIGURAS];
    private int numF=0;

    public void anyadeFigura(Figura f) {listaFiguras[numF++]=f;}

    public String toString(){
        String s= ""; for(int i=0;i < numF; i++) s+="\n"+listaFiguras[i];
        return s;
    }
    
    /**
     * Devuelve true sii la Figura F existe en listaFiguras
     */
    public boolean existeF (Figura f) {
        for (int i = 0; i <numF; i++) if (listaFiguras[i].equals(f)) return true;
        return false;
    }
    
    public double area() {
        double sum = 0;
        for (int i=0; i<numF; i++) sum += listaFiguras[i].area();
        return sum;
    }
    
    public double volumen() {
        double volTotal = 0;
        for (int i=0; i<numF; i++) 
            if (listaFiguras[i] instanceof Volumen) {
                Volumen figVol = (Volumen)listaFiguras[i];
                volTotal += figVol.volumen();
            }
        return volTotal;
    }
        
    public boolean equals (Object o) {
        if (o instanceof GrupoFiguras) {
            GrupoFiguras otro = (GrupoFiguras) o;
            // Comprobamos si las Figuras de ambos arrays son las mismas
            for (int i=0; i<this.numF; i++) 
                if (!(otro.existeF(this.listaFiguras[i]))) return false;
            for (int i=0; i<otro.numF; i++) 
                if (!(this.existeF(otro.listaFiguras[i]))) return false;            
              
            return true;
        } else return false;
    }    
}