public class Triangulo extends Figura{ 

    private double base, altura;

    public Triangulo (double x, double y, double base, double altura){ 
        super.x = x; 
        super.y = y; 
        this.base= base; 
        this.altura=altura;
    } 

    public String toString (){ 
        return "Triángulo:"+ "\n\tPosición("+x+","+y+ ")\n\tBase: "+base
            + "\n\tAltura: "+altura;
    }
    
    public double area() { return base*altura/2; }    
    
    public boolean equals (Object o) {
        boolean iguales = false;
        if (o instanceof Triangulo) {
            Triangulo otro = (Triangulo)o;
            iguales = this.x == otro.x &&
                      this.y == otro.y &&
                      this.base == otro.base &&
                      this.altura == otro.altura;
        }
        return iguales;
    }        
}