import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import librerias.implementacionesDeModelos.GrupoDeAL;

public class Test03
{
	public static boolean test() throws Throwable
	{
		final List<Numero> numeros = new LinkedList<Numero>();
		numeros.add(new Numero(1));
		numeros.add(new Numero(2));
		numeros.add(new Numero(3));
		numeros.add(new Numero(5));
		numeros.add(new Numero(7));

		final GrupoDeAL<Numero> grupoDe = new GrupoDeAL<Numero>();

		if (grupoDe.existe(new Numero(10)))
			return false;
		if (grupoDe.existe(new Numero(7)))
			return false;

		for (int numeroIndice = 0; numeroIndice < numeros.size(); numeroIndice++)
			grupoDe.anyade(numeros.get(numeroIndice));

		for (int numeroIndice = numeros.size() - 1; numeroIndice >= 0; numeroIndice--)
			if (!grupoDe.existe(numeros.get(numeroIndice)))
				return false;

		if (grupoDe.existe(new Numero(10)))
			return false;
		if (grupoDe.existe(new Numero(7)))
			return false;

		return true;
	}

	private static ArrayList<Numero> getArrayList(GrupoDeAL<Numero> grupoDe) throws Throwable
	{
		final List<Field> fieldsExcluded = new LinkedList<Field>();
		final Field[] fields = GrupoDeAL.class.getDeclaredFields();

		while (fieldsExcluded.size() < fields.length)
		{
			final Field field = Test03.getField(fields, "java.util.ArrayList", fieldsExcluded);
			final Class<?> fieldType = field.getType();
			final TypeVariable<?>[] typeParameters = fieldType.getTypeParameters();

			if (typeParameters.length == 1)
			{
				if (field == null)
					continue;

				field.setAccessible(true);
				return (ArrayList<Numero>) field.get(grupoDe);
			}
			fieldsExcluded.add(field);
		}

		if (((Object) grupoDe) instanceof ArrayList)
			return (ArrayList) (Object) grupoDe;

		return null;
	}
	private static Field getField(Class<?> clazz, String typeName, List<Field> fieldsExcluded)
	{
		final Field[] fields = GrupoDeAL.class.getDeclaredFields();

		return Test03.getField(fields, typeName, fieldsExcluded);
	}
	private static Field getField(Field[] fields, String typeName, List<Field> fieldsExcluded)
	{
		for (Field field : fields)
		{
			if (fieldsExcluded.contains(field))
				continue;

			final Class<?> fieldType = field.getType();
			final String fieldTypeName = fieldType.getName();

			if (fieldTypeName.equals(typeName))
				return field;
		}

		return null;
	}

	static class Numero
	{
		private int numero;

		public Numero(int numero)
		{
			this.numero = numero;
		}

		public int getNumero()
		{
			return this.numero;
		}

		public String toString()
		{
			return "Numero " + this.numero;
		}
	}
}