
/**
 * Clase utilizada para representar un cilindro.
 * 
 * @entity Universitat Politècnica de València
 * @author Josep Silva 
 * @version 12 Octubre 2014
 */

public class PrismaCuadrangular extends Cuadrado implements Volumen
{
    protected double altura;

    //Constructor
    public PrismaCuadrangular(double cx,double cy, double bas, double alt)
    {
        super(cx,cy,bas);
        this.altura = alt;
    }

    //Constructor
    public PrismaCuadrangular(Cuadrado cua, double alt)
    {
        this(cua.x,cua.y,cua.base,alt);
    }

    public double volumen()
    {
        return super.base*super.base*altura;   
    }    
}
