package librerias.implementacionesDeModelos;

import java.util.*;
import librerias.modelos.*;

/**
 * Implementa el modelo GrupoDe mediante un ArrayList.
 * 
 * @author (LTPP) 
 * @version (2014-15)
 */
public class GrupoDeAL<T> implements GrupoDe<T> {
   //Definicion de los atributos necesarios:
   private ArrayList<T> elArray;
  
   /** Constructor de GrupoDeAL */
   public GrupoDeAL() {
       elArray = new ArrayList<T>();
    }
   
    /** inserta un nuevo elemento en el GrupoDe */
    public void anyade(T e) {
        elArray.add(e);
    }
    
    /** Comprueba si existe un elemento en el GrupoDe */
    public boolean existe(T e) {
        for (int i=0; i<elArray.size(); i++)
            if (elArray.get(i).equals(e)) return true;
        return false;
    }
    
    /** Retorna el numero de elementos en el GrupoDe */
    public int talla() {
        return elArray.size();
    }
    
    /** Elimina, solo si existe, un elemento del GrupoDe 
     *  Devuelve el elemento si ha podido eliminarlo, 
     *  null en caso contrario     */ 
    public T elimina (T e) {
        for (int i=0; i<elArray.size(); i++)
            if (elArray.get(i).equals(e)) return elArray.remove(i);
        return null;
    }
    
    /** Retorna si el GrupoDe esta vacio */
    public boolean esVacio() { return elArray.size() == 0; }    
}    

