import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import librerias.implementacionesDeModelos.GrupoDeAL;

public class Test06
{
	public static boolean test() throws Throwable
	{
		final GrupoDeAL<Numero> grupoDe = new GrupoDeAL<Numero>();
		final Numero numero = new Numero(7);

		if (!grupoDe.esVacio())
			return false;
		grupoDe.anyade(numero);
		if (grupoDe.esVacio())
			return false;
		grupoDe.anyade(numero);
		if (grupoDe.esVacio())
			return false;
		grupoDe.elimina(numero);
		if (grupoDe.esVacio())
			return false;
		grupoDe.elimina(numero);
		if (!grupoDe.esVacio())
			return false;
		return true;
	}

	private static ArrayList<Numero> getArrayList(GrupoDeAL<Numero> grupoDe) throws Throwable
	{
		final List<Field> fieldsExcluded = new LinkedList<Field>();
		final Field[] fields = GrupoDeAL.class.getDeclaredFields();

		while (fieldsExcluded.size() < fields.length)
		{
			final Field field = Test06.getField(fields, "java.util.ArrayList", fieldsExcluded);
			final Class<?> fieldType = field.getType();
			final TypeVariable<?>[] typeParameters = fieldType.getTypeParameters();

			if (typeParameters.length == 1)
			{
				if (field == null)
					continue;

				field.setAccessible(true);
				return (ArrayList<Numero>) field.get(grupoDe);
			}
			fieldsExcluded.add(field);
		}

		if (((Object) grupoDe) instanceof ArrayList)
			return (ArrayList) (Object) grupoDe;

		return null;
	}
	private static Field getField(Class<?> clazz, String typeName, List<Field> fieldsExcluded)
	{
		final Field[] fields = GrupoDeAL.class.getDeclaredFields();

		return Test06.getField(fields, typeName, fieldsExcluded);
	}
	private static Field getField(Field[] fields, String typeName, List<Field> fieldsExcluded)
	{
		for (Field field : fields)
		{
			if (fieldsExcluded.contains(field))
				continue;

			final Class<?> fieldType = field.getType();
			final String fieldTypeName = fieldType.getName();

			if (fieldTypeName.equals(typeName))
				return field;
		}

		return null;
	}

	static class Numero
	{
		private int numero;

		public Numero(int numero)
		{
			this.numero = numero;
		}

		public int getNumero()
		{
			return this.numero;
		}

		public String toString()
		{
			return "Numero " + this.numero;
		}
	}
}