import java.util.*;
import java.util.Collection.*;
public class GrupoFiguras <T extends Figura> {   
    private ArrayList <T>  listaFiguras = new ArrayList<T>();

    public void anyadeFigura (T f) {
        if (!this.estaFiguraEnGrupo(f))
            listaFiguras.add(f);
    }
    
    public double area () {
        double a = 0.0;
        for (int i = 0; i < listaFiguras.size(); i++)
            a += listaFiguras.get(i).area();
        return a;
    }
   
   public void desplazaXY (double x, double y) {
        for (int i = 0; i < listaFiguras.size(); i++)
            listaFiguras.get(i).desplazaXY(x,y);
    }
    
   public void unir (GrupoFiguras<T> g){
    for (int i = 0; i < g.listaFiguras.size(); i++)
            this.anyadeFigura(g.listaFiguras.get(i));
    }
    
   private boolean estaFiguraEnGrupo(T f){
      for (int i = 0; i < listaFiguras.size(); i++)
        if (f.equals(listaFiguras.get(i)))return true;
      return false;
    }  
    
   public String toString () {
        String result = "";
        for (int i = 0; i < listaFiguras.size(); i++)
            result += listaFiguras.get(i).toString()+"\n";
        return result;
    }
    
}