import java.lang.reflect.Field;

public class TestHexaedroConstructor
{
	public static Boolean test(double posX, double posY, double arista) throws Throwable
	{
		final Class<?> figuraClass = Figura.class;
		final Class<?> poliedroClass = Poliedro.class;
		final Class<?> hexaedroClass = Hexaedro.class;

        // Si supieramos el nombre del atributo sería así:
        // final Field yField = figuraClass.getDeclaredField("x");
		final Field xField = figuraClass.getDeclaredFields()[0];//No sabemos el nombre del atributo
		final Field yField = figuraClass.getDeclaredFields()[1];//No sabemos el nombre del atributo
		final Field aristaField = poliedroClass.getDeclaredFields()[0];//No sabemos el nombre del atributo

		xField.setAccessible(true);
		yField.setAccessible(true);
		aristaField.setAccessible(true);

		final Hexaedro hexaedro = new Hexaedro(posX, posY, arista);
		final double xValue = (Double) xField.get(hexaedro);
		final double yValue = (Double) yField.get(hexaedro);
		final double aristaValue = (Double) aristaField.get(hexaedro);

		return xValue == posX && yValue == posY && aristaValue == arista;
	}
}