import java.lang.reflect.Field;

public class TestTetraedroConstructor
{
	public static boolean test(double posX, double posY, double arista) throws Throwable
	{
		final Class<?> figuraClass = Figura.class;
		final Class<?> poliedroClass = Poliedro.class;
		final Class<?> tetraedroClass = Tetraedro.class;

        // Si supieramos el nombre del atributo sería así:
        // final Field yField = figuraClass.getDeclaredField("x");
		final Field xField = figuraClass.getDeclaredFields()[0];//No sabemos el nombre del atributo
		final Field yField = figuraClass.getDeclaredFields()[1];//No sabemos el nombre del atributo
		final Field aristaField = poliedroClass.getDeclaredFields()[0];//No sabemos el nombre del atributo

		xField.setAccessible(true);
		yField.setAccessible(true);
		aristaField.setAccessible(true);

		final Tetraedro tetraedro = new Tetraedro(posX, posY, arista);
		final double xValue = (Double) xField.get(tetraedro);
		final double yValue = (Double) yField.get(tetraedro);
		final double aristaValue = (Double) aristaField.get(tetraedro);

		return xValue == posX && yValue == posY && aristaValue == arista;
	}
}