public class Test4_error
{
  private long[] data;

  private int len; 
/*
 *  Mtodo test4 que indica el numero maximo a evaluar
 **/
  public Test4_error(int max) 
  	{
    	data = new long[max];
    	len = 0;
  	}
/*
 *  Mtodo que ingresa los datos al vector
 **/
  public long insert(long value) 
  	{
    	data[len] = value; 
    	len++;
    	return value;
  	}
/*
 *  Mtodo que muestra los datos en pantalla
 **/
  public void display() 
  	{
    	System.out.print("Data:");
    	for (int j = 0; j < len; j++)
      		System.out.print(data[j] + " ");
    	System.out.println("");
  	}
/*
 *  Mtodo que hace iterativo el recorrido a la derecha
 **/
  public void quickSort() 
  	{
    	recQuickSort(0, len - 1);
  	}
/*
 *  Recibe como parmetro la posicin del elemento de la izquierda y derecha respectivamente.
 *  Este mtodo indica la posicin de los valores.
 *  Se obtiene la media de los elemntos y se realizan dos particionan
 *  Se realiza las comparaciones hacia derecha y posteriormente a la izquierda
 **/
  public void recQuickSort(int left, int right) 
  	{
    	int size = right - left + 1;
    	if (size < 10) // insertion sort if small
      		insertionSort(left, right);
    	else // quicksort if large
    	{
      		long median = medianOf3(left, right);
      		int partition = partitionIt(left, right, median);
      		recQuickSort(left, partition - 1);
      		recQuickSort(partition + 1, right);
    	}
  }
/**
 *  Recibe como parmetro la posicion derecha e izquierda de los elementos en el vector.
 *  Este mtodo manda hacer las ordenaciones de acuerdo a las condiciones que se presentan: de izquierda
 *  al centro, de izquierda a derecha  del centro a la derecha.
 *  Retorna la media de los elementos ordenados
 */
  public long medianOf3(int left, int right) 
  	{
    	int center = (left + right) / 2;
    	if (data[left] > data[center])// order left & center
      		swap(left, center);
    	if (data[left] > data[right])// order left & right
      		swap(left, right);
    	if (data[center] > data[right])// order center & right
      		swap(center, right);

    	swap(center, right - 1); 
    	return data[right - 1]; 
  	}
/*
 *	Recibe como parametros las posiciones de los elementos a ordenar
 *  Este mtodo realiza las ordenaciones pertinentes, haciendo uso de una temporal para realizar el ordenamiento de forma correcta
 *  Retorna los valores que estn siendo ordenados en cadena.
 **/
  public String swap(int d1, int d2) 
  	{
    	long temp = data[d1];
    	data[d1] = data[d2];
    	data[d2] = d1;
    
    	return ""+data[d2]+","+temp; 
  	}
/*
 *  Recibe como parametros la posicion derecha e izquierda y la media como pivote para particionar los elementos a ordenar
 *  Realiza el calculo de la nueva particin y se ordenan si se da el caso.
 *  Enva como parmetro el pivote (posicin del elemento a comparar)  
 **/
  public int partitionIt(int left, int right, long pivot) 
  	{
    	int leftPtr = left; // right of first elem
    	int rightPtr = right - 1; // left of pivot
    	while (true) 
    		{
      		//find bigger
      		while (data[++leftPtr] < pivot)
        		;
      		//find smaller
      		while (data[--rightPtr] > pivot)
        		;
      		if (leftPtr >= rightPtr) // if pointers cross, partition done
        		break;
      		else
        		swap(leftPtr, rightPtr);
    		}
    	swap(leftPtr, right - 1); // restore pivot
    	return leftPtr; // return pivot location
  }

/*
 *  Ingresa los datos del vector recorriendolos para obtener el vector ordenado 
 *
 **/
  public void insertionSort(int left, int right) 
  	{
    	int in, out;
    	for (out = left + 1; out <= right; out++) //  sorted on left of out
    		{
      		long temp = data[out]; // remove marked item
      		in = out; // start shifts at out
      		while (in > left && data[in - 1] >= temp) // until one is smaller,
      			{
        		data[in] = data[in - 1]; // shift item to right
        		--in; // go left one position
      			}
      		data[in] = temp; // insert marked item
    		}
  	}

  public static void main(String[] args) 
  	{
    	int maxSize = 16; 
    	Test4_error arr = new Test4_error(maxSize); 

    	for (int j = 0; j < maxSize; j++) 
    		{ 
      			long n = (int) (java.lang.Math.random() * 99);
      			arr.insert(n);
    		}
    	arr.display(); 
    	arr.quickSort();
    	arr.display(); 
  }
}