
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;


class Dado {
	
	private int valor;	// de 1 a 6
	private double val;	// variable temporal
	private char tipo; 	//a: attack; d: defend	


	public Dado (char t) {
		val = 100000*Math.random();
		valor = (int)val%6; // 0-5
		valor++; // 1-6
		tipo = t;
	}
	
	public int getValor () {
		return valor;
	}
	public void setValor (int v) {
		valor = v;
	}
	public int getTipo () {
		return tipo;
	}
	public void setValor (char t) {
		tipo = t;
	}
	
	// compara el dado con otro y devuelve true si es mejor dependiendo el tipo
	public boolean comparaDado (Dado a) {
		boolean mejor = false;
		if (tipo == 'd' && valor >= a.getValor()) mejor = true;
		if (tipo == 'a' && valor > a.getValor()) mejor = true;
		return mejor;
	}
	
	public String toString () {
		if (tipo == 'd') 
			return "Dado de defensa, valor: "+valor;
		else
			return "Dado de ataque, valor: "+valor;
	}

}


class Lector 
{
	// Atributos.
	private BufferedReader br = null;
	
	public Lector()
	{
		this.br = new BufferedReader(new InputStreamReader(System.in));
	}
	
	
	public byte leerByte()
	{
		byte tmp = 0;
		try 
		{
			tmp = Byte.parseByte(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un byte.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}

	
	public short leerShort()
	{
		short tmp = 0;
		try 
		{
			tmp = Short.parseShort(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un short.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
	
	
	public char leerChar()
	{
		char tmp = ' ';
		try 
		{
			tmp = br.readLine().charAt(0);
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}

	
	public int leerInt()
	{
		int tmp = 0;
		try 
		{
			tmp = Integer.parseInt(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un int.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
	
	
	public long leerLong()
	{
		long tmp = 0;
		try 
		{
			tmp = Long.parseLong(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un long.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}


	public float leerFloat()
	{
		float tmp = 0;
		try 
		{
			tmp = Float.parseFloat(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un float.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
	
	
	public double leerDouble()
	{
		double tmp = 0;
		try 
		{
			tmp = Double.parseDouble(br.readLine());
		}
		catch (NumberFormatException ex) 
		{
			System.out.println("Error: el dato introducido no se puede convertir en un double.");
			ex.printStackTrace();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
	
	
	public String leerString()
	{
		String tmp = null;
		try 
		{
			tmp = br.readLine();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
	
	
	public boolean leerBoolean()
	{
		boolean tmp = false;
		try 
		{
			tmp = new Boolean(br.readLine()).booleanValue();
		}
		catch (IOException ex) 
		{
			System.out.println("Error: hubo un problema en la operacin de entrada de datos.");
			ex.printStackTrace();
		}
		catch(Exception ex)
		{
			System.out.println("Error: hubo un problema no controlado.");
			ex.printStackTrace();
		}
		return tmp;
	}
}




public class test10 {
	public static void main (String[] args) {
		
		Lector leer = new Lector();

		int modo = 1;	// para manejar la opcion 6
		boolean winat1 = false;	// almacenar ataques
		boolean winat2 = false;	// almacenar ataques
		
		Dado a1= new Dado('a');Dado a2= new Dado('a');Dado a3= new Dado('a');
		Dado d1= new Dado('d');Dado d2= new Dado('d');
		
				if (a1.comparaDado(d1)) // true gana a1, ataque
					System.out.println("Gana ataque, -1 defensa");
				else 
					System.out.println ("Gana defensa, -1 ataque");
				System.out.println(a1.toString() +" "+ d1.toString());				

				if (a1.comparaDado(d1) && a1.comparaDado(d2)) 
					System.out.println("Gana ataque, -1 defensa");
				else	
					System.out.println("Gana defensa, -1 ataque");
				System.out.println(a1.toString() +" "+ d1.toString() +" "+ d2.toString());

				if (a1.comparaDado(d1) || a2.comparaDado(d1)) 
					System.out.println("Gana ataque, -1 defensa");
				else	
					System.out.println("Gana defensa, -1 ataque");
				System.out.println(a1.toString() +" "+ a2.toString() +" "+ d1.toString());

				if (a1.getValor() < a2.getValor()) {   //AQUI ESTA EL ERROR, EN LUGAR DE "<" ES ">"
					if (d1.getValor() > d2.getValor()) {
						winat1 = a1.comparaDado(d1);
						winat2 = a2.comparaDado(d2);
					} else {
						winat1 = a1.comparaDado(d2);
						winat2 = a2.comparaDado(d1);
					}
				} else { //a2>a1
					if (d1.getValor() > d2.getValor()) {
						winat1 = a2.comparaDado(d1);
						winat2 = a1.comparaDado(d2);
					} else {
						winat1 = a2.comparaDado(d2);
						winat2 = a1.comparaDado(d1);
					}
				}
				if (winat1 == winat2) {
					if (winat1 == true)
						System.out.println ("Gana ataque, -2 defensa");
					else
						System.out.println ("Gana defensa, -2 ataque");
				} else {
					System.out.println ("Empate, -1 ataque, -1 defensa");
				}
				System.out.println(a1.toString()+" "+a2.toString()+" "+d1.toString()+" "+d2.toString());
				if (a1.comparaDado(d1) || a2.comparaDado(d1) || a3.comparaDado(d1)) 
					System.out.println("Gana ataque, -1 defensa");
				else	
					System.out.println("Gana defensa, -1 ataque");
				System.out.println(a1.toString() + a2.toString() + a3.toString() + d1.toString());
				//ordeno, almaceno en int modo;
				if (a1.getValor()>a2.getValor() && a1.getValor()>a3.getValor())
					modo = 1;
				if (a1.getValor()>a3.getValor() && a1.getValor()>a2.getValor())
					modo = 2;
				if (a2.getValor()>a1.getValor() && a2.getValor()>a3.getValor())
					modo = 3;
				if (a2.getValor()>a3.getValor() && a2.getValor()>a1.getValor())
					modo = 4;
				if (a3.getValor()>a1.getValor() && a3.getValor()>a2.getValor())
					modo = 5;
				if (a3.getValor()>a2.getValor() && a3.getValor()>a1.getValor())
					modo = 6;
				// pongo los ataques en winat1/2
				switch (modo) {
					case 1: // a1, a2
						if (d1.getValor()>d2.getValor()) {
							winat1 = a1.comparaDado(d1);
							winat2 = a2.comparaDado(d2);
						} else {
							winat1 = a1.comparaDado(d2);
							winat2 = a2.comparaDado(d1);
						}
						break;
					case 2: //a1, a3
						if (d1.getValor()>d2.getValor()) {
							winat1 = a1.comparaDado(d1);
							winat2 = a3.comparaDado(d2);
						} else {
							winat1 = a1.comparaDado(d2);
							winat2 = a3.comparaDado(d1);
						}
						break;
					case 3: //a2, a1
						if (d1.getValor()>d2.getValor()) {
							winat1 = a2.comparaDado(d1);
							winat2 = a1.comparaDado(d2);
						} else {
							winat1 = a2.comparaDado(d2);
							winat2 = a1.comparaDado(d1);
						}
						break;
					case 4: //a2, a3
						if (d1.getValor()>d2.getValor()) {
							winat1 = a2.comparaDado(d1);
							winat2 = a3.comparaDado(d2);
						} else {
							winat1 = a2.comparaDado(d2);
							winat2 = a3.comparaDado(d1);
						}
						break;
					case 5: //a3, a1
						if (d1.getValor()>d2.getValor()) {
							winat1 = a3.comparaDado(d1);
							winat2 = a1.comparaDado(d2);
						} else {
							winat1 = a3.comparaDado(d2);
							winat2 = a1.comparaDado(d1);
						}
						break;
					case 6: //a3, a2
						if (d1.getValor()>d2.getValor()) {
							winat1 = a3.comparaDado(d1);
							winat2 = a2.comparaDado(d2);
						} else {
							winat1 = a3.comparaDado(d2);
							winat2 = a2.comparaDado(d1);
						}
						break;
				}
				if (winat1 == winat2) {
					if (winat1 == true)
						System.out.println ("Gana ataque, -2 defensa");
					else
						System.out.println ("Gana defensa, -2 ataque");
				} else {
					System.out.println ("Empate, -1 ataque, -1 defensa");
				}
				System.out.println(a1.toString()+" "+a2.toString()+" "+a3.toString());
				System.out.println(d1.toString()+" "+d2.toString());
	}
	
}