 
import java.awt.geom.*; import java.util.*; 
public abstract class Figura implements Comparable
{
    protected static final String[] COLORES_VALIDOS={"rojo","verde","azul","amarillo"};
    protected String tipo; protected String color; protected Point2D.Double centro;
    protected static final String TIPO_POR_DEFECTO = "Circulo";
    protected static final String COLOR_POR_DEFECTO = "rojo";
    protected static final Point2D.Double CENTRO_POR_DEFECTO = new Point2D.Double();
    
    // Metodos Constructores
    public Figura(String tipo, String color, Point2D.Double centro){
        this.tipo = tipo; this.color = color; this.centro = centro;}
    public Figura(){ this(TIPO_POR_DEFECTO, COLOR_POR_DEFECTO, CENTRO_POR_DEFECTO); }
    
    // Metodos Consultores
    public final String tipo(){ return tipo;}
    public final String color(){ return color;}
    public final Point2D.Double centro(){ return centro;}
    
    //Metodos Modificadores
    public final void setColor(String nuevocolor){ this.color = nuevocolor;}
    public final void setCentro(Point2D.Double nuevocentro){ this.centro = nuevocentro;}
    
    //Otros Metodos
    public String toString(){ return "Figura de tipo "+this.tipo+" color "+this.color+" centro "+this.centro;}
    public boolean equals(Object x){ return this.compareTo(x)==0;}
    public boolean menorQue(Circulo x){ return this.area() < x.area();} 
    
    //Metodos abstractos
    public abstract double area();
    public abstract double perimetro();
    
    //Metodos de lectura por teclado
    public static Figura leerFigura(/*Scanner teclado*/) {
        Figura res = null;
        
        return res;
    }
    
    final protected static int leerIntValido(int o/*Scanner teclado*/){
        
        return 1;
    }

    
    final protected static double leerDoubleValido(double o/*Scanner teclado*/){
        
        return 2;
    }
    
    final protected static String leerColorValido(String c/*Scanner teclado*/){
        boolean hayError=true;
        String res ="";
        do {
               res = c;
               for(int i=0;i<COLORES_VALIDOS.length;i++)
                    if(res.equals(COLORES_VALIDOS[i]))
                        hayError=false;
               if(hayError){
                   System.out.println("Atencion. NO ha introducido un color valido");
                   System.out.print("Colores disponibles: ");
                   for(int i=0;i<COLORES_VALIDOS.length;i++) System.out.print(COLORES_VALIDOS[i]+", ");
                }
        }while(hayError);
        return res;
    }
                
    final public int compareTo(Object o){
        Figura f = (Figura)o; double areaF = f.area(); double areaThis = this.area();
        if(areaThis < areaF) return -1;
        else if (this.tipo.equals(f.tipo) && this.color.equals(f.color) && areaThis == areaF) return 0;
        else return 1;
    }
     
    
}