 
public interface GrupoDeFiguras {
  /** inserta nueva en un Grupo de Figuras **/
  void insertar(Figura nueva);
  
  /** comprueba si aBuscar está en un Grupo de Figuras; si está devuelve
   *  su primera aparición en él y sino lo advierte lanzando la Excepción
   *  ElementoNoEncontrado
   **/
  Figura buscar(Figura aBuscar) throws ElementoNoEncontrado;
  /** borra la primera aparición de aBorrar en un Grupo de Figuras y 
    * la devuelve como resultado; si no fuera del Grupo lo advierte  
    * lanzando la Excepción ElementoNoEncontrado
    **/
  Figura borrar(Figura aBorrar) throws ElementoNoEncontrado;
  
  /** consulta la talla de un Grupo de Figuras **/
  int talla();
  
  /** calcula el área total del Grupo de Figuras sumando
   *  las áreas de las talla() Figuras que lo componen
   **/
  double area();
  
  /** obtiene en un String el número de Figuras de cada tipo  
   *  que hay en un Grupo
   **/
   String contarTipos();
  
  /** ordena un grupo de Figuras en orden creciente */ 
   void ordenar();
  /** obtiene la mayor Figura de un Grupo; si el grupo esta vacio lanza la excepcion 
   * Elemento no encontrado */
   Figura maxima() throws ElementoNoEncontrado;
   
   
  
}
