import java.util.*;  import java.awt.geom.*;
public class GrupoDeFigurasEnlazadas implements GrupoDeFiguras{
    //TIENE UNA ListaEnlazada de Figuras 
    private ListaEnlazada lEGFiguras;

    /** contruye un Grupo de Figuras vacío
     **/
    public GrupoDeFigurasEnlazadas(){
        this.lEGFiguras = new ListaEnlazada();
    }
    /** construye un Grupo de Figuras y lo inicializa 
     *  leyendo diversas Figuras desde teclado 
     **/
    public GrupoDeFigurasEnlazadas(int o/*Scanner teclado*/){
        this.lEGFiguras = new ListaEnlazada(); Figura aInsertar;
        aInsertar = new Circulo("rojo", new Point2D.Double(3,2), 3.2);//Figura.leerFigura(/*teclado*/);
        lEGFiguras.insertar(aInsertar);
        aInsertar = new Circulo("rojo", new Point2D.Double(32,12), 23.2);
        lEGFiguras.insertar(aInsertar);
        aInsertar = new Cuadrado("rojo", new Point2D.Double(1,12), 3.2);
        lEGFiguras.insertar(aInsertar);
        aInsertar = new Cuadrado("rojo", new Point2D.Double(4,22), 4.5);
        lEGFiguras.insertar(aInsertar);
       /* aInsertar = new Rectangulo("rojo", new Point2D.Double(6,22), 13.2, 22);
        lEGFiguras.insertar(aInsertar);
        aInsertar = new Rectangulo("rojo", new Point2D.Double(43,22), 4.5, 3.2);
        lEGFiguras.insertar(aInsertar);*/
        
    }
    
    /** inserta nueva en un Grupo de Figuras
     **/
    public void insertar(Figura nueva){
        this.lEGFiguras.insertar(nueva);

    }
    
    /** obtiene en un String la representación de un Grupo de Figuras
      **/
    public String toString(){
        return this.lEGFiguras.toString();
    }
    
    /** consulta la talla de un Grupo de Figuras
      **/
    public int talla(){
        return this.lEGFiguras.talla();
    }
    
    /** comprueba si aBuscar está en un Grupo de Figuras; si está devuelve 
     *  su primera aparición en él y sino lo advierte lanzando la Excepción
     *  ElementoNoEncontrado
     **/
    public Figura buscar(Figura aBuscar) throws ElementoNoEncontrado{
        Figura res;
        res = (Figura)lEGFiguras.buscar(aBuscar);
        return res;
    }
    
    /** borra la primera aparición de aBorrar en un Grupo de Figuras y 
     *  la devuelve como resultado; si no fuera del Grupo lo advierte 
     *  lanzando la Excepción ElementoNoEncontrado
    **/
    public Figura borrar(Figura aBorrar) throws ElementoNoEncontrado{ 
        Figura res;
        res = (Figura)lEGFiguras.borrar(aBorrar);
        return res;
    }  
    /** Recupera una Figura dado su indice */
    public Figura recuperar(int indice){
        Figura res;
        res = (Figura)lEGFiguras.recuperar(indice);
        return res;
    }
    
    /** calcula el área total del Grupo de Figuras sumando
     *  las áreas de las talla() Figuras que lo componen
     **/
    public double area(){
        double res = 0.0; Figura aux;
        if(lEGFiguras.talla() > 0)
            for(int i=0;i<lEGFiguras.talla();i++){
                aux = (Figura)lEGFiguras.recuperar(i);
                res=res+aux.area();
            }
        return res;
    }
     
    /** obtiene en un String el número de Figuras de cada tipo que hay en un Grupo
     **/
    public String contarTipos(){
        Figura aux; int cir=0, cua=0, rec=0;
        if(lEGFiguras.talla() > 0)
            for(int i=0;i<lEGFiguras.talla();i++)
            {
                aux = (Figura)lEGFiguras.recuperar(i);
                if ( aux instanceof Circulo ) cir++;
                else if ( aux instanceof Cuadrado) cua++;
                else rec++;
            }
        return "Numero de Figuras: "+lEGFiguras.talla()+"\nCiculos: "+cir+"\nRectangulos: "+rec+"\nCuadrados: "+cua+"\n";    
    }
    
    /** ordena por Inserción Directa un Grupo de Figuras en orden creciente de área **/
    public void ordenar(){
        Object aux1[] = lEGFiguras.toArray();
        Figura aux[] = new Figura[aux1.length];
        for(int i=0;i<aux1.length;i++)
            aux[i]=(Figura)aux1[i];
        Ordenacion.insercionDirecta(aux);
        this.lEGFiguras = new ListaEnlazada();
        for(int i=0;i<aux.length;i++)
            this.lEGFiguras.insertar((Figura)aux[i]);
        
    }
    public Figura maxima() throws ElementoNoEncontrado{
        Figura res = null;
        if(this.talla()==0) throw new ElementoNoEncontrado("El grupo esta vacio");
        this.ordenar();
        res = (Figura)lEGFiguras.recuperar(this.talla()-1);
        return res;    
    }
}

