
/** 
 *  La clase Ordenacion contiene algunos metodos de ordenacion de un array <br>
 *  de elementos de tipo Object que implementen el interfaz <b>Comparable</b>
 *  @author Professors de les assignatures PRG i EDA, dsic-etsia, UPV
 *  @since Nov 2003
 */

public class Ordenacion {

   // Metodo para intercambiar dos elementos de un array de Object
   private static void intercambiar(Object a[], int ind1, int ind2 )    
   {
       Object tmp = a[ind1];    
       a[ind1] = a[ind2];
       a[ind2] = tmp;   
   }

    // INSERCION DIRECTA -----------------------------------------------------------------------------

    /** 
     *  Ordenacion por insercion directa. <br> Los elementos del array, de tipo Object,
     *  deben implementar el interfaz Comparable. <br>
     *  No se utiliza centinela.
     *  @param a Todos sus elementos deben implementar el interfaz Comparable
     */
    public static void insercionDirecta(Object  a[]) { 
        for (int i = 1; i < a.length ; i++ ) {
            Comparable elemAInsertar = (Comparable)a[i];
            int posIns = i ;
            // Busqueda del lugar de insercion ordenada; 
            // desplazar mientras NO se encuentre 
            for (; posIns > 0 && elemAInsertar.compareTo(a[posIns-1]) < 0 ; posIns--) 
                a[posIns] = a[posIns - 1];
            // Insercion en posIns  
            a[posIns] = elemAInsertar;
       }
    }
 
    
    // SELECCION DIRECTA -----------------------------------------------------------------------------

    /** 
     *  Ordenacion por seleccion directa. <br> Los elementos del array, de tipo Object,
     *  deben implementar el interfaz Comparable
     *  @param a Todos sus elementos deben implementar el interfaz Comparable
     */
    public static void seleccionDirecta(Object a[]) {   
        for (int i=0; i<a.length-1; i++) {
            int posMin = i;
            for (int j=i+1; j<a.length; j++) if (((Comparable)a[j]).compareTo(a[posMin])<0) posMin = j;
            intercambiar(a,i,posMin);
        }
    }


    // QUICK SORT ------------------------------------------------------------------------------------
    
    /**
     *  Metodo para calculo de la Mediana de 3, devuelve el valor del pivote (Comparable)   
     */
   private static Comparable mediana3(Object  a[], int izq, int der )   
   {    
       int c=(izq+der)/2;   
       if (((Comparable)a[c]).compareTo(a[izq])<0)   intercambiar (a,izq,c);
       if (((Comparable)a[der]).compareTo(a[izq])<0) intercambiar (a,izq,der);
       if (((Comparable)a[der]).compareTo(a[c])<0)   intercambiar (a,c,der);
       // (ocultar el pivote en la posicion der-1
       intercambiar(a,c,der-1);
       return (Comparable)a[der-1];
   }

    /** 
     *  Algoritmo de ordenacion quicksort (Hoare -1963-). <br>
     *  Utiliza el algoritmo de <b>particion</b> debido a Weiss, con <b>mediana de 3</b> <br>
     *  para el calculo del pivote. <br>
     *  Los elementos del array <b>a</b>, de tipo Object, deben implementar el interfaz Comparable
     *  @param a Sus elementos deben implementar el interfaz Comparable
     */
   public static void quickSort(Object a[]) {
       quickSort(a, 0, a.length - 1);
   }

    /** 
     *  Algoritmo de ordenacion quicksort (Hoare -1963-). <br>
     *  Utiliza el algoritmo de <b>particion</b> debido a Weiss, con <b>mediana de 3</b> <br>
     *  para el calculo del pivote. <br>
     *  Los elementos del array <b>a</b>, de tipo Object, deben implementar el interfaz Comparable
     *  @param a Sus elementos entre <b>izq</b> y <b>der</b> deben implementar el interfaz Comparable
     *  @param izq indice del limite inferior a ser ordenado
     *  @param der indice del limite superior a ser ordenado
     */
   private static void quickSort(Object a[], int izq, int der )
   {
       if( izq<der )
       {
             Comparable pivot=mediana3(a,izq,der);
             int i=izq;
             int j=der-1;
             for( ; i<j; ) {    
                 while(pivot.compareTo(a[++i])>0);
                 while(pivot.compareTo(a[--j])<0);
                 intercambiar (a,i,j);
             }
             intercambiar (a,i,j);     // Deshacer el ultimo cambio
             intercambiar (a,i,der-1); // Restaurar el pivote
             quickSort(a,izq,i-1);     // Ordenar recursivamente los elementos menores
             quickSort(a,i+1,der);     // Ordenar recursivamente los elementos mayores
       }
   }


    // MERGE SORT ------------------------------------------------------------------------------------

    /** 
     *  Algoritmo de ordenacion mergesort. <br>
     *  Los elementos del array <b>v</b>, de tipo Object, deben implementar el interfaz Comparable
     *  @param v Sus elementos deben implementar el interfaz Comparable
     */
    public static void mergeSort(Object v[]) {
        mergeSort(v, 0, v.length - 1);
    }

    /** 
     *  Algoritmo de ordenacion mergesort. <br>
     *  Los elementos del array <b>v</b>, de tipo Object, deben implementar el interfaz Comparable
     *  @param v Sus elementos entre <b>izq</b> y <b>der</b> deben implementar el interfaz Comparable
     *  @param izq indice del limite inferior a ser ordenado
     *  @param der indice del limite superior a ser ordenado
     */
    private static void mergeSort(Object v[], int izq, int der) {
        if ( izq < der ) {
            int mitad = (izq + der) / 2;
            mergeSort(v, izq, mitad);
            mergeSort(v, mitad+1, der);
            mezclaNaturalDyV(v, izq, mitad+1, der);
        }
    }
    
    /**
     * Metodo de mezclaNatural para el algoritmo mergesort
     */
    private static void mezclaNaturalDyV(Object v[], int izqA, int izqB, int derB) {
        Object res[] = new Object[derB - izqA + 1];
        int i = izqA, derA = izqB - 1, j = izqB, k = 0;
        while ( i <= derA && j <= derB ) {
            if (((Comparable)v[i]).compareTo(v[i+1])<0) res[k] = v[i++];
            else res[k] = v[j++];
            k++;
        }
        for(int r = i; r <= derA; r++) res[k++] = v[r];
        for(int r = j; r <= derB; r++) res[k++] = v[r];
        // res se copia en v[izq ... der]
        for(int r = izqA; r <= derB; r++) v[r] = res[r-izqA];
    }
    
    
    // Metodos de comprobacion y auxialiares 

    /** 
     *  Para determinar si un array de Object, que implementen el interfaz Comparable <br> 
     *  esta o no ordenado ascendentemente. <br>
     *  @param a Sus elementos deben implementar el interfaz Comparable
     */
    public static boolean estaOrdenado(Object a[]) {
        boolean res = true; int i = 0;
        while(res && i<a.length-2){
            Comparable elemAComparar = (Comparable)a[i];
            if(elemAComparar.compareTo(a[i+1])>0)
                res = false;
            i++;
        }
        /*    if((Comparable)a[i].compareTo(a[i+1])>-1)
                res = false;*/
            
        return res;
    }
       

}
