import java.util.*;
public class Limit
{
    private String type;
    private ListaEnlazada points;
    private Zone zone;
    
    
    public Limit()
    {
        type = "fisico";
        this.zone = null;
        this.points = new ListaEnlazada();
    }

    public Limit(Zone newZone, String newType)
    {
        type = newType;
        this.zone = newZone;
        this.points = new ListaEnlazada();
    }

    public void addVertex(float x, float y)
    {
        this.points.add(new RTEAsimPoint(x, y));
    }

    public void clearVertexes() 
    {
        this.points.clear();
    }

    public int getNumberOfVertexes()
    {
        return this.points.size();
    }

    public RTEAsimPoint getVertexN(int n)
    {
       // if(n < this.points.size())
            return (RTEAsimPoint)this.points.get(n);
        //else
          //  throw new RTEAsimException("Limit::getVertexN(int n)","The parameter n is out of bounds", 103);
    }

    public void setType(String newType)
    {
        this.type = newType;
    }

    public String getType()
    {
        return this.type;
    }

    public void setZone(Zone newZone)
    {
        this.zone = newZone;
    }

    public Zone getZone()
    {
        return this.zone;
    }

    public void recuperarMaximos(float[] AUX)
    {
        for(int i = 0; i < points.size(); i++)
        {
            if(((RTEAsimPoint)points.get(i)).getX() > AUX[0])
                AUX[0] = ((RTEAsimPoint)points.get(i)).getX();
            if(((RTEAsimPoint)points.get(i)).getY() > AUX[1])
                AUX[1] = ((RTEAsimPoint)points.get(i)).getY();
        }
    }
    
    public boolean Contains(float x, float y)
    {
    /* Declaracion de las variables que me haran falta, inicializo xMax e yMax con las coordenadas del primer vertice del limite */
    float xMax = ((RTEAsimPoint)points.get(0)).getX(), yMax = ((RTEAsimPoint)points.get(0)).getY(), a, b, c, aa, bb, cc, xInterseccion, yInterseccion;
    int cont = 0, vertices = 0;
    /* Primero busco las coordenadas x e y maximas (xMax e yMax) de los vertices del limite, para poder elegir un punto con las coordenadas x > xMax 
     e y > yMax */
    float AUX[] = new float[2];
    AUX[0] = xMax;
    AUX[1] = yMax;
    recuperarMaximos(AUX);
    xMax = AUX[0];
    yMax = AUX[1];
    
    boolean seguir = false;
    float vector[] = new float[3];
    while(!seguir)
    {
        seguir = true;
        cont = 0;
        vertices = 0;
        /* Hago mayores la xMax y la yMax para que esten fuera del limite */ 
        xMax = xMax * 2;
        yMax = yMax * 4;
        /* Ahora obtengo los coeficientes de la ecuacion implicita de la recta que pasa por el punto a estudiar y por el punto que esta fuera del limite, 
        Esta ecuacion es del tipo ax + by + c = 0 por ello le pasamos a la funcion ObtainCoefficients las coordenadas del punto a estudiar, las del punto exterior 
        y las direcciones de memoria de las variables a, b y c, donde se guardaran los coeficientes de la recta. Para mejor comprension llamare a esta recta la recta maestra */
        this.ObtainCoefficients(x, y, xMax, yMax, vector);
        a = vector[0];
        b = vector[1];
        c = vector[2];
        /* Ahora viene la parte mas complicada, voy a iterar por todos los vertices desde el primero hasta el penultimo para calcular la ecuacion de la recta que 
        pasa por ese vertice y el siguiente (es decir, calcular las ecuaciones de las rectas que forman el limite. 
        Y mientras ir calculando las intersecciones de estas rectas con la recta maestra */
        for(int i = 0; i < points.size()-1; i++)
        {
            this.ObtainCoefficients(((RTEAsimPoint)points.get(i)).getX(), ((RTEAsimPoint)points.get(i)).getY(), ((RTEAsimPoint)points.get(i+1)).getX(), ((RTEAsimPoint)points.get(i+1)).getY(), vector);
            aa = vector[0];
            bb = vector[1];
            cc = vector[2];
            /* Ahora calculamos la interseccion de las dos rectas, pero si no fuera posible por que fueran paralelas pasamos el booleano seguir a false para recalcular xMax e yMax y calcular de nuevo todo */
            if(this.ObtainIntersection(a, b, c, aa, bb, cc, vector) == false)
            {
                seguir = false;
            }
            xInterseccion = vector[0];
            yInterseccion = vector[1];
            /* Ahora bien, hes calculado rectas infinitas, hay que  ver si la interseccion pertenece al segmento que definen el punto a estudiar (x,y) y el punto exterior al limite (xMax,yMax)
            si es asi, sumamos al contador de intersecciones "cont" */
            if(xInterseccion <= this.Max(((RTEAsimPoint)points.get(i)).getX(), ((RTEAsimPoint)points.get(i+1)).getX()) && xInterseccion >= this.Min(((RTEAsimPoint)points.get(i)).getX(), ((RTEAsimPoint)points.get(i+1)).getX()) && xInterseccion > x 
                && yInterseccion <= this.Max(((RTEAsimPoint)points.get(i)).getY(), ((RTEAsimPoint)points.get(i+1)).getY()) && yInterseccion >= this.Min(((RTEAsimPoint)points.get(i)).getY(), ((RTEAsimPoint)points.get(i+1)).getY()))
            {
                cont++;
                /* Pero hay un problema con los vertices, con este metodo, si la interseccion pasa por un vertice, se contarian 2 intersecciones, una cuando es el principio del lado y otra cuando es 
                el final, por ello compruebo si la interseccion es un vertice, y sumo al contador de "vertices" */
                if((xInterseccion == ((RTEAsimPoint)points.get(i)).getX() && yInterseccion == ((RTEAsimPoint)points.get(i)).getY()) 
                    || (xInterseccion == ((RTEAsimPoint)points.get((int)this.Min(points.size()-1, i+1))).getX() && yInterseccion == ((RTEAsimPoint)points.get((int)this.Min(points.size()-1, i+1))).getY()))
                    vertices++;
            }
        
        }
        /* Por ultimo, compruebo si el limite es abierto o cerrado, si es cerrado (el primer y el ultimo  vertice iguales) no hace falta hacer nada mas 
        pero si es abierto hay que calcular la recta que une el primer y ultimo vertice para completar los calculos */
        if(((RTEAsimPoint)points.get(0)).getX() != ((RTEAsimPoint)points.get(points.size()-1)).getX() || ((RTEAsimPoint)points.get(0)).getY() != ((RTEAsimPoint)points.get(points.size()-1)).getY())
        {
            this.ObtainCoefficients(((RTEAsimPoint)points.get(0)).getX(), ((RTEAsimPoint)points.get(0)).getY(), ((RTEAsimPoint)points.get(points.size()-1)).getX(), ((RTEAsimPoint)points.get(points.size()-1)).getY(), vector);
            aa = vector[0];
            bb = vector[1];
            cc = vector[2];
            if(this.ObtainIntersection(a, b, c, aa, bb, cc, vector) == false)
            {

                seguir = false;
            }
            xInterseccion = vector[0];
            yInterseccion = vector[1];
            if(xInterseccion <= this.Max(((RTEAsimPoint)points.get(0)).getX(), ((RTEAsimPoint)points.get(points.size()-1)).getX()) && xInterseccion >= this.Min(((RTEAsimPoint)points.get(0)).getX(), ((RTEAsimPoint)points.get(points.size()-1)).getX()) && xInterseccion > x 
                && yInterseccion <= this.Max(((RTEAsimPoint)points.get(0)).getY(), ((RTEAsimPoint)points.get(points.size()-1)).getY()) && yInterseccion >= this.Min(((RTEAsimPoint)points.get(0)).getY(), ((RTEAsimPoint)points.get(points.size()-1)).getY()))
                cont++;
        }
    }
    /* Ahora le resto al contador de intersecciones el numero de vertices / 2, para quitar las intersecciones duplicadas, pues si una de las intersecciones es un vertice 
    se contaria dos veces. */
    cont = cont - vertices / 2;
    /* Y ahora si, si el numero de vertices es impar, el punto x,y esta dentro del limite, si es par no lo esta. */
    if(cont%2 == 0)
        return false;
    else
        return true; 
}


public void ObtainCoefficients(float p1x, float p1y, float p2x, float p2y, float vector[])
{
    float a, b, c;
    
    a = p2y - p1y;
    b = p1x - p2x;
    c = p1y * (p2x - p1x) -p1x * (p2y - p1y);
    vector[0] = a;
    vector[1] = b;
    vector[2] = c;
}

public boolean ObtainIntersection(float a, float b, float c, float aa, float bb, float cc, float vector[])
{
    float xInters, yInters;
    if(bb - (aa * b) / a == 0 ||a == 0)
        return false;
    yInters = (((aa * c) / a) - cc) / (bb - (aa * b) / a);
    xInters = (-b * yInters - c) / a;
    vector[0] = xInters;
    vector[1] = yInters/a; //el /a sobra, es para que el Jdd tenga algo para depurar
    return true;
}

public float Max(float a, float b)
{
    if(a>b)
        return a;
    else
        return b;
}

public float Min(float a, float b)
{
    if(a<b)
        return a;
    else
        return b;
}


}
