public class ListaEnlazada {

    protected NodoLista primero;
    protected int talla;
    
    /** crea una LEG vaca*/
    public ListaEnlazada(){
        this.primero = null;
        this.talla = 0;
    }
    
    public void clear(){ this.primero = null; this.talla = 0;}
    
    /** inserta un Objeto x en una LEG */
    public void add(Object x){
        primero = new NodoLista(x, primero);
        this.talla++;
    }
    
    /** consulta la talla de una LEG*/
    public int size(){
        return this.talla;
    }
    
    /** SII talla() != 0 AND 0 <= i < talla(): devuelve el i-simo Objeto de una LEG */
    public Object get(int i){
       NodoLista aux = primero; int j = 0;
       while (  j < i ) { 
           aux = aux.siguiente;
           j++;
       }
       return aux.dato;
    }
    
    /** borra la primera aparicin del Objeto aBorrar en una LEG y la  
     *  devuelve como resultado; si no fuera de la Lista lo advierte lanzando
     *  la Excepcin ElementoNoEncontrado
     **/
    public Object borrar(Object aBorrar){
        NodoLista  aux = primero, ant = null;
        while ( aux != null && !aux.dato.equals(aBorrar) ){
            ant = aux;
            aux = aux.siguiente;
        }
        if ( aux == null )
            return null;
        if ( ant == null )  primero = aux.siguiente;
        else ant.siguiente = aux.siguiente;
        this.talla--;
        return aux.dato;
    }
    
    /** comprueba si aBuscar est en una LEG; si est devuelve su primera aparicin 
     *  en ella y sino lo advierte lanzando la Excepcin ElementoNoEncontrado
     **/
     public Object buscar(Object aBuscar){
        NodoLista  aux = primero;
        while ( aux != null && !aux.dato.equals(aBuscar) ) aux = aux.siguiente;
        if ( aux == null )
            return null;
        return aux.dato;
    }
     
    /** obtiene en un String la representacin de una LEG */
    public String toString(){
        String res = "";
        for ( NodoLista aux = primero; aux != null; aux = aux.siguiente )
            res += aux.dato.toString()+" ";
        return res;
    }
    
    /** obtiene un array cuyas componentes son los talla() Objetos de una LEG*/
    public Object [] toArray(){
        Object copia[]= new Object[this.talla];
        NodoLista aux; int i;
        for ( aux = primero, i = 0; aux != null; aux = aux.siguiente, i++)
           copia[i] = aux.dato;
        return copia;
    }
}