import java.util.*;
public class Zone
{
   private Limit externalLimit;
   private ListaEnlazada internalLimits;
   private Zone parent;
   private ListaEnlazadaZ subZones;
   private int level;
   private RTEAsimPoint origin;
   private double alfa;
   private String IDObject;
//   private HashMap accesses;
   
public Zone(String name)
{
    this.internalLimits = new ListaEnlazada();
    this.subZones = new ListaEnlazadaZ();
    this.IDObject = name;
    this.parent = null;
    this.externalLimit = new Limit();
    this.origin = null;
    this.level = 0;
    this.alfa = 0;
}

public Zone(String name, float x, float y, double alfa)
{
    this.internalLimits = new ListaEnlazada();
    this.subZones = new ListaEnlazadaZ();
    this.IDObject = name;
    origin = new RTEAsimPoint(x,y);
    this.alfa = alfa;
    this.parent = null;
    this.externalLimit = new Limit();
    this.level = 0;
} 
public String getIDObject()
{
    return this.IDObject;
}
public boolean Contains(float x, float y)
{
   boolean res = true;
   for(int i = 0; i < internalLimits.size(); i++)
       if(((Limit)internalLimits.get(i)).Contains(x,y))
           res = false;
   if(res == true)
       return externalLimit.Contains(x, y);
   else
       return false;
}

public void setExternalLimit(Limit newLimitE)
{
   this.externalLimit = newLimitE;
   this.externalLimit.setZone(this);
}

public Limit getExternalLimit()
{
   return this.externalLimit;
}

public void addInternalLimit(Limit ILimit)
{
    this.internalLimits.add(ILimit);
    ILimit.setZone(this);
}

public int getNumberOfInternalLimits()
{
    return this.internalLimits.size();
}

public Limit getInternalLimitN(int n)
{
    //if(n < this.internalLimits.size())
        return (Limit)this.internalLimits.get(n);
    //else
    //  throw RTEAsimException("public getInternalLimitN(int n)","The parameter n is out of bounds", 104);
}

public void clearInternalLimits()
{
    this.internalLimits.clear();
}

public void setParent(Zone newParent)
{
    this.parent = newParent;
}

public Zone getParent()
{
    return this.parent;
}

public void addSubZone(Zone newSubZone)
{
    subZones.put(newSubZone.getIDObject(), newSubZone); 
    newSubZone.setParent(this);
}

public int getNumberOfSubZones()
{
    return this.subZones.size();
}

public Zone getSubZoneByID(String ID, int mode)
{
    Zone res = null;
    res = (Zone)this.subZones.get(ID);
    return res;
}

public boolean removeSubZone(String ID)
{
    try{
    this.subZones.remove(ID);
        return true;
    }catch(Exception e) {
     return false;}
    
}


public void setLevel(int newLevel)
{
    this.level = newLevel;
}

public int getLevel()
{
    return this.level;
}


public void setOrigin(float x, float y)
{
    this.origin = new RTEAsimPoint(x,y);
}

public RTEAsimPoint getOrigin()
{
    return this.origin;
}


public double getOriginOrientation()
{
    return this.alfa;
}

public void setOriginOrientation(double newAlfa)
{
    this.alfa = newAlfa;
}
/*
public void addAccess(Access newAccess)
{
    this.accesses.add(newAccess);
}

public void clearAccesses()
{
    this.accesses.clear();
}

////////////////////////////////////////////////////////////////////////
// Name:       public getNumberOfAccesses()
// Purpose:    Implementation of public getNumberOfAccesses()
// Comment:    Funcion que recupera el numero de Accesos de la zona
// Return:     void
////////////////////////////////////////////////////////////////////////

public int getNumberOfAccesses() 
{
    return this.accesses.size();
}

////////////////////////////////////////////////////////////////////////
// Name:       public getAccessN()
// Purpose:    Implementation of public getAccessN()
// Comment:    Funcion que recupera el acceso n-esimo de la zona, recibe como parametro de tipo int con el n-esimo acceso de la zona a recuperar
// Return:     void
////////////////////////////////////////////////////////////////////////

public Access getAccessN(int n)
{
    if(n < this.accesses.size())
        return this.accesses.get(n);
    
}

////////////////////////////////////////////////////////////////////////
// Name:       public exportar()
// Purpose:    Implementation of public exportar()
// Comment:    devuelve una cadena que parametriza los datos del objeto para ser recreados en una posterior carga del sistema.
// Return:     String
////////////////////////////////////////////////////////////////////////



*/
}
