
public class Programa7 {
	
	public static void multiplica(int iTabla, int iNumero)
	{
		multiplicarRR(iTabla,iNumero);
		multiplicarSS(iTabla,iNumero);
	}
	
	public static void multiplicarRR(int iTabla, int iNumero)
	{
		if (iNumero>1)
			multiplicarRR(iTabla,iNumero-1);		
		
		System.out.println(iTabla + "x" + iNumero + "=" + iTabla*iNumero + " " + fibonacciR(iTabla*iNumero));
		
	}
    
	public static void multiplicarSS(int iTabla, int iNumero)
	{
		for (int i=1; i<=iNumero; i++)
		{
			System.out.println(iTabla + "x" + i + "=" + iTabla*i + " " + fibonacciS(iTabla*i));
		}
		
	}
	
	public static int fibonacciR(int num)
	{
		if ((num == 0) || (num == 1))
			return 1;
		else
			return fibonacciR(num-1) + fibonacciR(num-2);
		    	
	}
	
	public static int fibonacciS(int n)
	{
		int actual, ant1, ant2;
		ant1 = ant2 = 1;
		actual=0;
		int i;
		if ((n == 0) || (n == 1)) {
			actual = 1;
		} 
		else{
			for (i=2; i<=n; i++) {
				actual = ant1 + ant2;
				ant2 = ant1;
				ant1 = actual;
			}
		}
		return actual;
	}
	
	public static void bubbleSort1(int[] x) {
	    int n = x.length;
	    for (int pass=1; pass < n; pass++) {  // count how many times
	        // This next loop becomes shorter and shorter
	        for (int i=0; i < n-pass; i++) {
	            if (x[i] > x[i+1]) {
	                // exchange elements
	                int temp = x[i];  x[i] = x[i+1];  x[i+1] = temp;
	            }
	        }
	    }
	}

	public static void bubbleSort2(int[] x) {
	    boolean doMore = true;
	    while (doMore) {
	        doMore = false;  // assume this is last pass over array
	        for (int i=0; i<x.length-1; i++) {
	            if (x[i] > x[i+1]) {
	               // exchange elements
	               int temp = x[i];  x[i] = x[i+1];  x[i+1] = temp;
	               doMore = true;  // after an exchange, must look again 
	            }
	        }
	    }
	}


	public static void bubbleSort3(int[] x) {
	    int n = x.length;
	    boolean doMore = true;
	    while (doMore) {
	        n--;
	        doMore = false;  // assume this is our last pass over the array
	        for (int i=0; i<n; i++) {
	            if (x[i] > x[i+1]) {
	                // exchange elements
	                int temp = x[i];  x[i] = x[i+1];  x[i+1] = temp;
	                doMore = true;  // after an exchange, must look again 
	            }
	        }
	    }
	}//end method bubbleSort3

	public static void bubbleSort4(int[] x) {
	    int newLowest = 0;            // index of first comparison
	    int newHighest = x.length-1;  // index of last comparison
	  
	    while (newLowest < newHighest) {
	        int highest = newHighest;
	        int lowest  = newLowest;
	        newLowest = x.length;    // start higher than any legal index
	        for (int i=lowest; i<highest; i++) {
	            if (x[i] > x[i+1]) {
	               // exchange elements
	               int temp = x[i];  x[i] = x[i+1];  x[i+1] = temp;
	               if (i<newLowest) {
	                   newLowest = i-1;
	                   if (newLowest < 0) {
	                       newLowest = 0;
	                   }
	               } else if (i>newHighest) {
	                   newHighest = i+1;
	               }
	            }
	        }
	    }
	}//end method bubbleSort4
	
	public static void main(String[] args) {
		int[] a={9, 11, 15, 16, 20, 24, 27, 29, 22, 20, 14, 9};
		multiplica(1,3);
		multiplica(2,3);
		multiplica(3,3);
		bubbleSort1(a);
		bubbleSort2(a);
		bubbleSort3(a);
		bubbleSort4(a);
	}
	
}
