-----------------------------------------------------------
-- Count the number of solutions to the "n queens" problem
-----------------------------------------------------------

nsoln nq = length (gen nq)
 where
    safe :: Int -> Int -> [Int] -> Bool
    safe x d []    = True
    safe x d (q:l) = x /= q && x /= q+d && x /= q-d && safe x (d+1) l

    gen :: Int -> [[Int]]
    gen 0 = [[]]
    gen n = [ (q:b) | b <- gen (n-1), q <- [1..nq], safe q 1 b]

--main = print $ nsoln 0
--main = print $ nsoln 2
--main = print $ nsoln 4
--main = print $ nsoln 6
--main = print $ nsoln 8
--main = print $ nsoln 10
