package test;

public class Loops
{
	public static void main(String[] args)
	{
		final double x = 123;
		double result;

		System.out.println("==============");
		System.out.println("  While loop");
		System.out.println("==============");
		result = Loops.whileSQRT(x);
		System.out.println("result = " + result + "\n");

		System.out.println("============");
		System.out.println("  For loop");
		System.out.println("============");
		result = Loops.forSQRT(x);
		System.out.println("result = " + result + "\n");

		System.out.println("============");
		System.out.println("  Do loop");
		System.out.println("============");
		result = Loops.doSQRT(x);
		System.out.println("result = " + result + "\n");
	}

	public static double whileSQRT(double x)
	{
		if (x < 0)
			return Double.NaN;

		double b = x;
		while (Math.abs(b * b - x) > 1e-12)
			b = ((x / b) + b)/2;

		return b;
	}
	public static double forSQRT(double x)
	{
		if (x < 0)
			return Double.NaN;

		double b = x;
		for (int iter = 1; Math.abs(b * b - x) > 1e-12; iter++)
		{
			b = ((x / b) + b) / 2;
			System.out.println(iter + ") " + b);
		}

		return b;
	}
	public static double doSQRT(double x)
	{
		if (x < 0)
			return Double.NaN;
		if (x == 0 || x == 1)
			return x;

		double b = x;
		do
			b = ((x / b) + b) / 2;
		while (Math.abs(b * b - x) > 1e-12);

		return b;
	}
}