module Re2hsBasics where

numLines :: String	-- the code before a point
         -> Int		-- the number of newlines before this point
numLines xs = length (filter (== '\n') xs)

indent :: String	-- the code before this point 
       -> Int		-- the number of spaces required to be used
			-- to indent the a string to the same point
indent before = lengthS (reverse (takeWhile (/= '\n') (reverse before)))

lengthS :: String	-- a string
        -> Int		-- the length of it, taking tab chars into account
lengthS xs = lengths xs 0
 where
  lengths :: String  -- the rest of the current string 
          -> Int     -- the length up to this point
          -> Int     -- the length of the string with latest
                     -- character handled, leapt forward
                     -- to next tab stop if necessary.
  lengths [] n = n
  lengths ('\t':xs) n = lengths xs ((8 - (n `mod` 8)) + n )
  lengths (x:xs) n = lengths xs (n+1)


mkSpaces :: Int		-- how many spaces we want 
         -> String	-- a string containing that many spaces
mkSpaces n = take n (repeat ' ')
