module ShowFormXML where

import HXML
import DeleteBlnFromXML


sepBln::Int
maxLengthElement::Int
sepBln = 3
maxLengthElement = 80

blancos 0 = []
blancos n = " ":(blancos (n-1))

attrFormat (x,y) =[(" ")++x++("=")++("\"")++y++("\"")]

showFormattedXML'' prof (Tree (ELNode name attr) [])  = (concat(blancos (prof*sepBln)))++("<")++(name)++(concat(concat(map attrFormat attr)))++(">\n")++(concat(blancos (prof*sepBln)))++("</")++(name)++(">\n")
showFormattedXML'' prof (Tree (TXNode text) [])  = (concat(blancos (prof*sepBln)))++(text)++("\n")
showFormattedXML'' prof (Tree (ENNode text) [])  = (concat(blancos (prof*sepBln)))++(text)++("\n")
showFormattedXML'' prof (Tree (CXNode text) [])  = (concat(blancos (prof*sepBln)))++(text)++("\n")
showFormattedXML'' prof (Tree (ELNode name attr) [Tree (TXNode text)[]]) = if (((2*(length name))+(length text)+5+(prof*sepBln))>maxLengthElement) 
									 then (concat(blancos (prof*sepBln)))++("<")++(name)++(concat(concat(map attrFormat attr)))++(">\n")++(concat(blancos ((prof+1)*sepBln)))++text++("\n")++(concat(blancos (prof*sepBln)))++("</")++(name)++(">\n")
									 else (concat(blancos (prof*sepBln)))++("<")++(name)++(concat(concat(map attrFormat attr)))++(">")++text++("</")++(name)++(">\n")
		
showFormattedXML'' prof (Tree (ELNode name attr) args) = (concat(blancos (prof*sepBln)))++("<")++(name)++(concat(concat(map attrFormat attr)))++(">\n")++(concat(map (showFormattedXML'' (prof+1)) args))++(concat(blancos (prof*sepBln)))++("</")++(name)++(">\n")				 
		  
showFormattedXML' (Tree RTNode trees) = showFormattedXML'' 0 (head trees)