function [dm, ma]=detmaxns(ca,np,s,n,dopt)
% [dm ma]=detmaxns(ca,np,s,n,dopt)
% Ds-optimum exact designs with np runs are obtained from candidate matriz points ca in n attempts (Mitchell's DETMAX algorithm)
% s is the number of parameters that are relevant (and must correspond to the s first columns in ma)
% s must be < number of columns in ca. (For s = number of columns in ca, use standar software for D-optimality criterion)
% For RPD problems, when all the factors are quantitatives, ca can be obtained by means of genca function
% In each row of ma the row number (in ca) corresponding to the optimum design obtained are saved
% If ma has more than one row, several equivalent different designs has been obtained
% dm is the value of the D/D2 criterion for the obtained optimum(s) design(s)
% dopt (optional) is the value of the D/D2 criterion for the optimal continuous design. If dopt is given Ds-efficiency is obtained
% Read the adjoint readme.txt document for more information
[nf nc]=size(ca);
if s>nc; error('s must be < number of columns in ca'); end
if s==nc; error('s = number of columns in ca. Use standar software for D-optimality criterion'); end
TOL=1e-6;i=0; ma=[]; dm=0; de=[]; dsa=[];
while n>i
  [id,ds,nd,dt]=detmaxs(ca,np,s); 
  i=i+1; ma=[ma;nd]; dsa=[dsa;max(ds)]; de=[de,dt];
  if (dt-dm) >TOL* dm , dm=dt; end
end
ma=ma(dm-de<TOL*dm,:); dsa=dsa(dm-de<TOL*dm); [no,i]=size(ma);se=ones(1,no);disp(' ');
for i=1:no-1
  for j=i+1:no
   if all(ma(i,:)==ma(j,:)), se(j)=0; end
  end
end
ma=ma(se==1,:); dsa=dsa(se==1); [n1,i]=size(ma);
disp(' ');disp(['D/D2 = ',sprintf('%e',dm),'    ds = ',sprintf('%6.2f',dsa(1))])
if nargin==5;disp(' '); disp(['Ds-Efficiency : ',sprintf('%6.1f',100*(dm/dopt)^(1/s)),'%']); end
disp(' ');disp(['Gs-Efficiency : ',sprintf('%6.1f',100*s/dsa(1)),'%'])
disp(' '); disp(['Number of equivalent different optimum designs found :',sprintf('%3i',n1)]);
disp(' ');disp(['Optimal designs found',sprintf('%3i',no),' times in',sprintf('%4i',n),' attempts'])    