function [dopt,id]=dsopt(ca,s,np)
% computes aproximated Ds-optimum continuous design for point candidate matrix ca and s relevant parameters in the model
% Ds-optimum design is aproximated by an exact design with np points (is np argument is omited ==> np = 1000
% dopt is the value of the D/D2 Ds-optimality criterion for the quasi Ds_optimum continuous design obtained
% id contains the weigths (as percentages) of the candidate points in the quasi Ds_optimum continuous design
n=1000; if nargin==3; n=np; end
[dopt nd]=detmaxns(ca,n,s,1);
id=100*ndid(ca,nd)/n;