function [ca,nf]=genca(c,n)
% computes the candidate point matrix ca for Model(3.1) (RPD studies) for c control and n noise quantitative factors
% the numbers of ca columns corresponding to control and noise factors are saved in nf
ca=expand(plan(c,3),plan(n,2)); x=ca(:,1:c);y=ca(:,(c+1):(c+n));
ca=[ones(3^c*2^n,1) x x.^2 pcross(x) cruz(x,y) y pcross(y)]; [ro co]=size(ca);
nin=n*(n-1)/2; nf=[2:(c+1) (co+1-nin-n):(co-nin)];
fprintf(1,'\n\n point candidate matrix has %6i rows and %4i columns. %4i parameters are relevant\n\n',ro,co,co-nin);
